<?php
require_once __DIR__ . '/../lib/db.php';
$pdo = get_pdo();
$msg='';

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_FILES['csv'])){
  $tmp=$_FILES['csv']['tmp_name'];
  $f=fopen($tmp,'r'); $hdr=fgetcsv($f); // skip header
  $ins=$pdo->prepare("INSERT INTO students (first_name,last_name,house_code,year_level,dob,student_code) VALUES (?,?,?,?,?,?)");
  $count=0;
  while(($row=fgetcsv($f))!==false){
    if(count($row)<5) continue;
    [$first,$last,$house,$year,$dob,$code]=array_pad($row,6,null);
    $ins->execute([$first,$last,$house,(int)$year,$dob,$code]);
    $count++;
  }
  fclose($f);
  $msg="Uploaded {$count} students.";
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Upload Students</title><link rel="stylesheet" href="assets/styles.css"/></head>
<body>
<header class="header"><div class="brand">Upload Students</div><nav class="nav"><a href="index.php">Back</a></nav></header>
<main class="container">
  <section class="card">
    <h2>CSV Upload</h2>
    <p>Columns: <code>first_name,last_name,house_code,year_level,dob(YYYY-MM-DD),student_code</code></p>
    <?php if($msg): ?><p class="badge"><?= htmlspecialchars($msg) ?></p><?php endif; ?>
    <form method="post" enctype="multipart/form-data">
      <input type="file" name="csv" accept=".csv" class="input" required/>
      <p><button class="button">Upload</button></p>
    </form>
  </section>
</main>
</body>
</html>
