
// Podium-only renderer (safe, no style changes).
// Drop this <script> after your existing markup and BEFORE any other scripts that might break,
// or temporarily comment out other scripts and include this one.
//
// It fetches event_api.php?action=overall_grid and populates:
//   - #pod-first, #pod-second, #pod-third
//   - #next-list
(function(){
  const $ = id => document.getElementById(id);
  const cls = code => (code || '').toUpperCase();
  const safe = n => (typeof n === 'number' && isFinite(n)) ? n : 0;

  function pillar(el, label, row){
    if (!el) return;
    const name = row && row.house_name ? row.house_name : '—';
    const pts  = safe(row && row.overall);
    el.innerHTML = '<div class="block"><span class="vertical"></span></div><div class="base"></div>';
    const v = el.querySelector('.vertical');
    const base = el.querySelector('.base');
    v.textContent = name + ' (' + pts + ')';
    base.textContent = label;
    base.className = 'base ' + (label==='1st' ? 'first' : label==='2nd' ? 'second' : 'third');
    const blk = el.querySelector('.block');
    if (row && row.house_code) blk.classList.add('house-banner', cls(row.house_code));
  }

  function nextList(rows){
    const host = $('next-list');
    if (!host) return;
    host.innerHTML = (rows || []).map((r,i) =>
      '<div class="rank-row">' +
        '<div class="rank-num">'+(i+4)+'th</div>' +
        '<span class="house-chip '+cls(r.house_code)+'">'+r.house_name+'</span>' +
        '<div class="points">'+safe(r.overall)+'</div>' +
      '</div>'
    ).join('');
  }

  function render(rows){
    if (!Array.isArray(rows)) rows = [];
    rows.sort((a,b)=> safe(b.overall) - safe(a.overall));
    const t0 = rows[0] || {house_name:'—', house_code:'', overall:0};
    const t1 = rows[1] || {house_name:'—', house_code:'', overall:0};
    const t2 = rows[2] || {house_name:'—', house_code:'', overall:0};
    pillar($('pod-first'),  '1st', t0);
    pillar($('pod-second'), '2nd', t1);
    pillar($('pod-third'),  '3rd', t2);
    nextList(rows.slice(3,6));
  }

  async function go(){
    let raw = '';
    try{
      const res = await fetch('event_api.php?action=overall_grid', { headers:{'Accept':'application/json'} });
      raw = await res.text();
      const data = JSON.parse(raw);
      if (data && data.ok) render(Array.isArray(data.rows) ? data.rows : []);
      else {
        console.warn('overall_grid not ok:', data);
        render([]);
      }
    }catch(err){
      console.error('overall_grid parse/network error:', err, '\nRaw response:', raw.slice(0,200));
      render([]);
    }
  }

  document.addEventListener('DOMContentLoaded', go);
})();
