
// PDM podium-only script (namespaced, no style changes)
(function(){
  const log = (...a) => console.log('[PDM]', ...a);
  const $ = id => document.getElementById(id);
  const cls = code => (code || '').toUpperCase();
  const safe = n => (typeof n === 'number' && isFinite(n)) ? n : 0;

  function pillar(el, label, row, max){
    if (!el) { log('missing element for', label); return; }
    const name = row && row.house_name ? row.house_name : '—';
    const pts  = safe(row && row.overall);
    const MIN = 120, MAX = 240;
    const h = max>0 ? Math.round((pts/max)*(MAX-MIN)+MIN) : MIN;

    el.innerHTML = '<div class="block"><span class="vertical"></span></div><div class="base"></div>';
    const v = el.querySelector('.vertical');
    const base = el.querySelector('.base');
    const blk = el.querySelector('.block');
    v.textContent = name + ' (' + pts + ')';
    base.textContent = label;
    base.className = 'base ' + (label==='1st' ? 'first' : label==='2nd' ? 'second' : 'third');
    if (row && row.house_code) blk.classList.add('house-banner', cls(row.house_code));
    blk.style.height = h + 'px';
  }

  function nextList(rows){
    const host = $('next-list');
    if (!host) { log('no #next-list'); return; }
    host.innerHTML = (rows||[]).map((r,i)=>
      '<div class="rank-row">' +
        '<div class="rank-num">'+(i+4)+'th</div>' +
        '<span class="house-chip '+cls(r.house_code)+'">'+r.house_name+'</span>' +
        '<div class="points">'+safe(r.overall)+'</div>' +
      '</div>'
    ).join('');
  }

  function render(rows){
    if (!Array.isArray(rows)) rows = [];
    rows.sort((a,b)=> safe(b.overall) - safe(a.overall));
    const top3 = [rows[0], rows[1], rows[2]].map(r => r || {house_name:'—', house_code:'', overall:0});
    const max = safe(top3[0].overall);
    pillar($('pod-first'),  '1st', top3[0], max);
    pillar($('pod-second'), '2nd', top3[1], max);
    pillar($('pod-third'),  '3rd', top3[2], max);
    nextList(rows.slice(3,6));
    log('rendered podium; rows:', rows.length);
  }

  async function go(){
    try{
      const r = await fetch('event_api.php?action=overall_grid', { headers:{'Accept':'application/json'} });
      const t = await r.text();
      log('raw len:', t.length);
      let d; try { d = JSON.parse(t); } catch(e){ log('JSON parse error', e, t.slice(0,120)); return; }
      if (d && d.ok) render(Array.isArray(d.rows) ? d.rows : []);
      else { log('endpoint not ok', d); }
    }catch(err){
      log('network error', err);
    }
  }

  // run after DOM is ready
  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', go);
  else go();
})();
