<?php require_once __DIR__ . '/../lib/db.php'; $pdo=get_pdo(); ?>
<!doctype html>
<html>
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>TBC Athletics — Participation</title>
<link rel="stylesheet" href="assets/styles.css"/><script defer src="assets/app.js"></script>
</head>
<body>
<header class="header">
  <div class="brand">TBC Athletics — Participation</div>
  <nav class="nav">
    <a href="index.php">Overall</a>
    <a href="competitive.php">Competitive</a>
    <a href="participation.php">Participation</a>
    <a href="event_entry.php">Field Entry</a>
  </nav>
</header>

<main class="container">
  <section class="card">
    <div class="grid grid-3">
      <div><label>Division</label><select id="partDiv" class="input"><option value="Participation">Participation</option></select></div>
      <div><label>Scheduled Event</label><select id="partEvent" class="input"></select></div>
      <div><label>Year Level</label><select id="partYear" class="input"><option value="">All</option><option>9</option><option>10</option><option>11</option><option>12</option><option>13</option></select></div>
    </div>
    <div class="grid">
      <div class="flex justify-between"><h2>Add Participation</h2><input id="search" class="input" placeholder="Search students…"/></div>
      <table class="table" id="studentsTbl"><thead></thead><tbody></tbody></table>
    </div>
  </section>
</main>

<script>
let studentsRows=[];

async function loadScheduledParticipation(){
  const res = await api('scheduled_events', {division:'Participation'});
  const sel=document.getElementById('partEvent'); sel.innerHTML='';
  for(const r of res.rows){
    const opt=document.createElement('option');
    opt.value=r.id; opt.textContent=r.event_name + (r.year_list?(' — Y'+r.year_list):'');
    sel.appendChild(opt);
  }
}
async function loadStudents(){
  const year=document.getElementById('partYear').value||null;
  const res=await api('students',{year_level:year}); studentsRows=res.rows; renderStudents();
}
function renderStudents(){
  const q=document.getElementById('search').value.toLowerCase();
  const rows=studentsRows.filter(r=>(r.first_name+' '+r.last_name).toLowerCase().includes(q));
  const cols=[
    {key:'student',label:'Student',render:r=> `${r.last_name}, ${r.first_name} <span class="badge ${r.house_code}">${r.house_code}</span>`},
    {key:'year_level',label:'Year'},
    {key:'action',label:'Participated',render:r=> `<button class="button secondary" onclick="markParticipation(${r.id})">+1</button>`},
    {key:'final',label:'Finalist',render:r=> `<button class="button" onclick="markFinalist(${r.id})">Mark Finalist</button>`},
  ];
  renderTable(document.getElementById('studentsTbl'), rows, cols);
}
async function markParticipation(student_id){
  const sched_id=parseInt(document.getElementById('partEvent').value);
  await api('add_participation',{sched_id,student_id,finalist:false});
  alert('Saved');
}
async function markFinalist(student_id){
  const sched_id=parseInt(document.getElementById('partEvent').value);
  await api('add_participation',{sched_id,student_id,finalist:true});
  alert('Finalist saved');
}
document.getElementById('partYear').addEventListener('change', loadStudents);
document.getElementById('search').addEventListener('input', renderStudents);
loadScheduledParticipation(); loadStudents();
</script>
</body>
</html>
