<?php
require_once __DIR__ . '/common.php';
if (!isset($page_title)) $page_title = 'TBC Athletics';
if (!isset($active)) $active = '';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($page_title) ?></title>

  <!-- Always resolve from /public -->
  <link rel="stylesheet" href="<?= url('assets/styles.css') ?>">
  <script defer src="<?= url('assets/app.js') ?>"></script>
</head>
<body>
<header class="header">
  <div class="brand">
    <img src="<?= url('assets/TBCCrest.png') ?>" alt="Tauranga Boys' College crest" class="Headercrest">
    TBC Athletics
  </div>

  <nav class="nav">
    <a href="<?= url('index.php') ?>"         class="<?= $active==='overall'?'active':'' ?>">Overall</a>
    <a href="<?= url('competitive.php') ?>"   class="<?= $active==='competitive'?'active':'' ?>">Competitive</a>
    <a href="<?= url('participation.php') ?>" class="<?= $active==='participation'?'active':'' ?>">Participation</a>
    <a href="<?= url('event_entry.php') ?>"   class="<?= $active==='entry'?'active':'' ?>">Field Entry</a>
  </nav>
</header>
<main class="<?= isset($container_class) ? $container_class : 'container' ?>">

