<?php
// public/partials/common.php
if (!defined('COMMON_BOOTSTRAPPED')) {
  define('COMMON_BOOTSTRAPPED', true);

  // Filesystem paths
  $publicFs = realpath(__DIR__ . '/..');                 // …/TBC_athletics_app/public
  $docroot  = isset($_SERVER['DOCUMENT_ROOT']) ? realpath($_SERVER['DOCUMENT_ROOT']) : '';

  // Compute web URL path to /public (e.g. /SIM/TBC_athletics_app/public)
  if ($docroot && $publicFs && strpos($publicFs, $docroot) === 0) {
    $PUBLIC_URL = str_replace($docroot, '', $publicFs);
    if ($PUBLIC_URL === '') $PUBLIC_URL = '/';
  } else {
    // Fallback to PHP_SELF dir if docroot mapping isn't available
    $PUBLIC_URL = rtrim(dirname($_SERVER['PHP_SELF']), '/');
  }

  // Helper to build URLs relative to /public
  function url($path) {
    global $PUBLIC_URL;
    return rtrim($PUBLIC_URL, '/') . '/' . ltrim($path, '/');
  }
}
