
// LB leaderboard-only script (namespaced; no style changes)
(function(){
  const log = (...a) => console.log('[LB]', ...a);
  const $ = id => document.getElementById(id);
  const safe = v => (typeof v === 'number' && isFinite(v)) ? v : 0;
  const cls  = code => (code || '').toUpperCase();

  function renderRowsLB(rows){
    const body = $('lbBody');
    if (!body) { log('no #lbBody'); return; }
    if (!Array.isArray(rows) || rows.length === 0){
      body.innerHTML = '<tr><td colspan="22" style="text-align:center;padding:16px">No data yet</td></tr>';
      return;
    }
    body.innerHTML = rows.map(r => `
      <tr class="house-row ${cls(r.house_code)}">
        <td class="col-code"><strong>${r.house_code ?? ''}</strong></td>
        <td class="col-house" style="text-align:left;font-weight:800">${r.house_name ?? ''}</td>

        <td class="gap" aria-hidden="true"></td>

        <td class="first-in-group">${safe(r.jun_comp)}</td>
        <td>${safe(r.jun_part)}</td>
        <td class="emph">${safe(r.jun_total)}</td>
        <td>${r.jun_rank ?? ''}</td>

        <td class="gap" aria-hidden="true"></td>

        <td class="first-in-group">${safe(r.int_comp)}</td>
        <td>${safe(r.int_part)}</td>
        <td class="emph">${safe(r.int_total)}</td>
        <td>${r.int_rank ?? ''}</td>

        <td class="gap" aria-hidden="true"></td>

        <td class="first-in-group">${safe(r.sen_comp)}</td>
        <td>${safe(r.sen_part)}</td>
        <td class="emph">${safe(r.sen_total)}</td>
        <td>${r.sen_rank ?? ''}</td>

        <td class="gap" aria-hidden="true"></td>

        <td class="first-in-group emph">${safe(r.tot_comp)}</td>
        <td class="emph">${safe(r.tot_part)}</td>
        <td class="emph" style="font-size:20px">${safe(r.overall)}</td>
        <td>${r.overall_rank ?? ''}</td>
      </tr>
    `).join('');
  }

  async function getRows(){
    const res = await fetch('event_api.php?action=overall_grid', { headers: {'Accept':'application/json'} });
    const txt = await res.text();
    let data;
    try { data = JSON.parse(txt); }
    catch(e){ log('JSON parse error:', e, txt.slice(0,150)); return []; }
    if (!data || data.ok !== true) { log('endpoint not ok', data); return []; }
    const arr = Array.isArray(data.rows) ? data.rows.slice() : [];
    arr.sort((a,b)=> safe(b.overall) - safe(a.overall));
    return arr;
  }

  async function runLB(){
    const rows = await getRows();
    renderRowsLB(rows);
    log('rendered rows:', rows.length);
  }

  // run late to avoid other scripts wiping tbody afterwards
  if (document.readyState === 'complete') setTimeout(runLB, 0);
  else window.addEventListener('load', () => setTimeout(runLB, 0), { once: true });

  // wire refresh button if present
  const btn = $('btnRefresh');
  if (btn) btn.addEventListener('click', () => runLB().catch(console.error));
})();
