<?php
require_once __DIR__ . '/../lib/db.php';
$pdo = get_pdo();
$page_title = 'TBC Athletics — Overall';
$active = 'overall';
$container_class = 'container container-wide';
include __DIR__ . '/partials/header.php';
?>

<!-- Page-local styles for the single-table leaderboard with true gaps -->
<style>
  /* Gutter cells between blocks (real columns, not borders) */
  .lb .gap { width:12px; min-width:12px; padding:0; border:none !important; background:transparent !important; }
  .lb thead .gap { border:none !important; background:transparent !important; }

  /* Header looks like your mock; Code/House only appear on the 2nd header row */
  .lb { border-collapse:separate; border-spacing:0; width:100%; }
  .lb th, .lb td { border:2px solid #0b2230; padding:8px 10px; text-align:center; }
  .lb thead tr:first-child th { background:#cfd8e3; font-weight:900; font-size:20px; }
  .lb thead tr:first-child th.totals { background:#dff3d9; }
  .lb thead tr:nth-child(2) th { background:#d7dee6; font-style:italic; font-weight:600; }
  .lb thead tr:nth-child(2) th.sub { background:#e6ecf3; font-style:normal; font-weight:600; }

  /* House colour rows */
  .lb tr.house-row td { color:#fff; }
  .lb tr.house-row.HL td, .lb tr.house-row.NG td { color:#111; }
  .lb tr.house-row.FR td { background:var(--FR); }
  .lb tr.house-row.HB td { background:var(--HB); }
  .lb tr.house-row.HL td { background:var(--HL); }
  .lb tr.house-row.NR td { background:var(--NR); }
  .lb tr.house-row.NG td { background:#ffffff; }
  .lb tr.house-row.RF td { background:var(--RF); }
  /* but keep the gap cells transparent */
  .lb tr.house-row td.gap { background:transparent !important; }

  /* Emphasis on totals like your sheet */
  .lb td.emph { font-weight:900; font-size:18px; }
</style>

<section class="card">
  <div class="flex justify-between items-center">
    <div class="flex items-center">
      <img src="assets/TBClogoHorizontal.jpg" alt="Tauranga Boys' College crest" class="crest">
      <h1 class="podium-title">Athletics Day 2026 - Podium</h1>
    </div>
    <button class="button" onclick="loadOverall()">Refresh</button>
  </div>



  <div class="podium-wrap">
    <div class="podium">
      
      <div id="pod-second" class="pillar"></div>
      <div id="pod-first"  class="pillar"></div>
      <div id="pod-third"  class="pillar"></div>
    </div>

    <div class="next-three">
      <h3>4th – 6th Places</h3><p>
      <div id="next-list"></div>
    </div>
  </div>
</section>

<section class="card">
  <div class="flex justify-between">
    <h2>House Leaderboard</h2>
  </div>

  <div class="table-wrap">
    <table class="table lb" id="lbTbl">
      
      <colgroup>
        <col class="c-code">
        <col class="c-house">
        <col class="gap">

        <!-- Junior (4) -->
        <col class="c-metric"><col class="c-metric"><col class="c-metric"><col class="c-metric">
        <col class="gap">

        <!-- Inter. (4) -->
        <col class="c-metric"><col class="c-metric"><col class="c-metric"><col class="c-metric">
        <col class="gap">

        <!-- Senior (4) -->
        <col class="c-metric"><col class="c-metric"><col class="c-metric"><col class="c-metric">
        <col class="gap">

        <!-- Totals (Comp, Part, Overall, Rank) -->
        <col class="c-metric"><col class="c-metric"><col class="c-overall"><col class="c-metric">
      </colgroup>

    
    <thead id="lbHead">
        <!-- Row 1: block titles. Code/House cells are blank here (no rowspans) -->
        <tr>
          <th class="TableBlank" colspan="2"></th>
          
          <th class="gap" aria-hidden="true"></th>

          <th class="group first-in-group" colspan="4">Junior</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="group first-in-group" colspan="4">Intermediate</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="group first-in-group" colspan="4">Senior</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="group totals first-in-group" colspan="4">Totals</th>
        </tr>

        <!-- Row 2: Code/House + subheaders for each block -->
        <tr>
          <th class="col-code">Code</th>
          <th class="col-house">House</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="sub first-in-group">Comp</th><th class="sub">Part</th><th class="sub">Total</th><th class="sub">Rank</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="sub first-in-group">Comp</th><th class="sub">Part</th><th class="sub">Total</th><th class="sub">Rank</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="sub first-in-group">Comp</th><th class="sub">Part</th><th class="sub">Total</th><th class="sub">Rank</th>
          <th class="gap" aria-hidden="true"></th>

          <th class="sub first-in-group">Comp</th><th class="sub">Part</th><th class="sub">Overall</th><th class="sub">Rank</th>
        </tr>
      </thead>
      <tbody id="lbBody"></tbody>
    </table>
  </div>
</section>

<script>
// ---------- Podium helpers ----------
function heightPx(points, max){ const MIN=70, MAX=200; if(max<=0) return MIN; const h = Math.round((points/max)*(MAX-MIN)+MIN); return Math.max(MIN, Math.min(MAX,h)); }
function labelText(name, pts){ return `${name} (${pts})`; }
function houseClass(code){ return (code||'').toUpperCase(); }

function renderPillar(el, rankLabel, row /*, max */){
  const baseClass = rankLabel==='1st' ? 'base first'
                  : rankLabel==='2nd' ? 'base second'
                  : 'base third';
  el.innerHTML = `
    <div class="block">
      <span class="vertical">${row.house_name} (${row.overall})</span>
    </div>
    <div class="${baseClass}">${rankLabel}</div>
  `;
  // keep house colour on the block
  el.querySelector('.block').classList.add('house-banner', houseClass(row.house_code));
}


function renderNext(rows){
  const box = document.getElementById('next-list');
  box.innerHTML = rows.map((r,i)=>`
    <div class="rank-row">
      <div class="rank-num">${i+4}th</div>
      <span class="house-chip ${houseClass(r.house_code)}">${r.house_name}</span>
      <div class="points">${r.overall}</div>
    </div>`).join('');
}

// ---------- Leaderboard (single table with gap columns) ----------
function renderRows(rows){
  const body = document.getElementById('lbBody');
  if (!rows || !rows.length){
    body.innerHTML = `<tr><td colspan="23" style="text-align:center;padding:16px">No data yet</td></tr>`;
    return;
  }
  body.innerHTML = rows.map(r => `
    <tr class="house-row ${houseClass(r.house_code)}">
      <td class="col-code"><strong>${r.house_code}</strong></td>
      <td class="col-house" style="text-align:left;font-weight:800">${r.house_name}</td>

      <td class="gap" aria-hidden="true"></td>

      <td class="first-in-group">${r.jun_comp}</td>
      <td>${r.jun_part}</td>
      <td class="emph">${r.jun_total}</td>
      <td>${r.jun_rank}</td>
      <td class="gap" aria-hidden="true"></td>

      <td class="first-in-group">${r.int_comp}</td>
      <td>${r.int_part}</td>
      <td class="emph">${r.int_total}</td>
      <td>${r.int_rank}</td>
      <td class="gap" aria-hidden="true"></td>

      <td class="first-in-group">${r.sen_comp}</td>
      <td>${r.sen_part}</td>
      <td class="emph">${r.sen_total}</td>
      <td>${r.sen_rank}</td>
      <td class="gap" aria-hidden="true"></td>

      <td class="first-in-group emph">${r.tot_comp}</td>
      <td class="emph">${r.tot_part}</td>
      <td class="emph" style="font-size:20px">${r.overall}</td>
      <td>${r.overall_rank}</td>
    </tr>
  `).join('');
}


// ---------- Main loader ----------
/* --- Minimal, robust API helper just for this page --- */
async function api(action, payload) {
  // event_api.php lives in /public alongside index.php
  const url = 'event_api.php' + (action ? `?action=${encodeURIComponent(action)}` : '');
  const res = await fetch(url, payload ? {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify(payload)
  } : { method: 'GET' });

  const text = await res.text();           // read raw (could be HTML)
  try {
    return JSON.parse(text);               // try JSON first
  } catch (e) {
    // Show first 400 chars so we can see the real PHP error instead of “Unexpected token '<'”
    alert(`${action} error: ${e.message}\n\n${text.slice(0, 400)}`);
    throw e;
  }
}

/* --- everything below is your existing load/render logic, unchanged --- */
function heightPx(points, max){
  const MIN=70, MAX=200; if(max<=0) return MIN;
  const h = Math.round((points / max) * (MAX - MIN) + MIN);
  return Math.max(MIN, Math.min(MAX, h));
}
function labelText(name, pts){ return `${name} (${pts})`; }
function houseClass(code){ return (code||'').toUpperCase(); }

function buildHeader(){
  const head = document.getElementById('lbHead');
  head.innerHTML = `
    <tr>
      <th rowspan="2" class="lefthead">Code</th>
      <th rowspan="2" class="lefthead">House</th>
      <th colspan="4" class="section">Junior</th>
      <th colspan="4" class="section">Inter.</th>
      <th colspan="4" class="section">Senior</th>
      <th colspan="4" class="section totals">Totals</th>
    </tr>
    <tr>
      <th>Comp</th><th>Part</th><th>Total</th><th>Rank</th>
      <th>Comp</th><th>Part</th><th>Total</th><th>Rank</th>
      <th>Comp</th><th>Part</th><th>Total</th><th>Rank</th>
      <th>Comp</th><th>Part</th><th>Overall</th><th>Rank</th>
    </tr>
  `;
}

<?php
include __DIR__ . '/partials/footer.php';
?>
