<?php ?>
<!doctype html>
<html>
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>TBC Athletics — Competitive</title>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<link rel="stylesheet" href="assets/styles.css"/><script defer src="assets/app.js"></script>
</head>
<body>
<header class="header">
  <div class="brand">TBC Athletics — Competitive</div>
  <nav class="nav">
    <a href="index.php">Overall</a>
    <a href="competitive.php">Competitive</a>
    <a href="participation.php">Participation</a>
    <a href="event_entry.php">Field Entry</a>
  </nav>
</header>
<main class="container">
  <section class="card">
    <div class="flex justify-between">
      <h2>Top 3 — Final Results</h2>
      <button class="button" onclick="loadCompetitive()">Refresh</button>
    </div>
    <table class="table" id="compTbl"><thead></thead><tbody></tbody></table>
  </section>
</main>
<script>
async function loadCompetitive(){
  const res = await api('competitive_table');
  const cols = [
    {key:'event_name',label:'Event'},
    {key:'place',label:'Place'},
    {key:'competitor',label:'Competitor'},
    {key:'result_value',label:'Result',render:r=> r.result_value + ' ' + r.result_unit},
  ];
  renderTable(document.getElementById('compTbl'), res.rows, cols);
}
loadCompetitive();
</script>





</body>
</html>
