async function api(action, payload={}) {
  const res = await fetch('api.php?action=' + encodeURIComponent(action), {
    method:'POST',
    headers:{'Content-Type':'application/json'},
    body: JSON.stringify(payload)
  });
  if(!res.ok) throw new Error('API error');
  return await res.json();
}

function renderTable(tbl, rows, columns){
  const thead = tbl.tHead || tbl.createTHead();
  const tbody = tbl.tBodies[0] || tbl.createTBody();
  thead.innerHTML=''; tbody.innerHTML='';
  const trh = thead.insertRow();
  for(const c of columns){
    const th=document.createElement('th'); th.textContent=c.label; trh.appendChild(th);
  }
  for(const r of rows){
    const tr=tbody.insertRow();
    for(const c of columns){
      const td=tr.insertCell();
      td.innerHTML = c.render ? c.render(r) : (r[c.key] ?? '');
    }
  }
}
