<?php
header('Content-Type: application/json');
session_start();

require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/scoring.php';

$pdo = get_pdo();
$action = $_GET['action'] ?? '';
$input = json_decode(file_get_contents('php://input'), true) ?? [];

try {
  switch ($action) {
    case 'overall_grid':
      echo json_encode(['ok'=>true,'rows'=>get_house_breakdown($pdo)]);
      break;
      
    case 'overall':
      $totals = get_house_totals($pdo);
      $rows=[];
      foreach($totals as $code=>$t){
        $rows[]=['house_code'=>$code,'house_name'=>$t['house_name'],'competitive'=>$t['competitive'],'participation'=>$t['participation'],'total'=>$t['total']];
      }
      echo json_encode(['ok'=>true,'rows'=>$rows]); break;

    case 'houses':
      echo json_encode(['ok'=>true,'rows'=>get_houses($pdo)]); break;

    case 'students':
      $q = "SELECT id,first_name,last_name,house_code,year_level FROM students WHERE 1=1";
      $p=[];
      if(!empty($input['year_level'])){ $q.=" AND year_level=:y"; $p[':y']=(int)$input['year_level']; }
      if(!empty($input['house_code'])){ $q.=" AND house_code=:h"; $p[':h']=$input['house_code']; }
      $q.=" ORDER BY last_name, first_name LIMIT 500";
      $st=$pdo->prepare($q); $st->execute($p);
      echo json_encode(['ok'=>true,'rows'=>$st->fetchAll()]); break;

    case 'scheduled_events':
      $q = "SELECT se.id, e.name AS event_name, se.division, se.year_min, se.year_max, se.year_list, se.is_team, se.location, se.start_time
            FROM scheduled_events se JOIN events e ON e.id=se.event_id WHERE 1=1";
      $p=[];
      if(!empty($input['division'])){ $q.=" AND se.division=:d"; $p[':d']=$input['division']; }
      $q.=" ORDER BY e.name";
      $st=$pdo->prepare($q); $st->execute($p);
      echo json_encode(['ok'=>true,'rows'=>$st->fetchAll()]); break;

    case 'add_participation':
      $st = $pdo->prepare("INSERT INTO participation_entries (sched_id,student_id,finalist,created_by)
                           VALUES (:s,:u,:f,:by) ON DUPLICATE KEY UPDATE finalist=VALUES(finalist)");
      $st->execute([':s'=>(int)$input['sched_id'], ':u'=>(int)$input['student_id'], ':f'=>!empty($input['finalist'])?1:0, ':by'=>($_SESSION['staff_name'] ?? 'api')]);
      echo json_encode(['ok'=>true]); break;

    case 'add_competitive':
      $st = $pdo->prepare("INSERT INTO competitive_results
        (sched_id,student_id,house_code,result_value,result_unit,place,heat,round,status,wind)
        VALUES (:s,:stu,:house,:val,:unit,:place,:heat,:round,:status,:wind)");
      $st->execute([
        ':s'=>(int)$input['sched_id'],
        ':stu'=>isset($input['student_id']) && $input['student_id'] ? (int)$input['student_id'] : null,
        ':house'=>($input['house_code'] ?? null) ?: null,
        ':val'=>(float)($input['result_value'] ?? 0),
        ':unit'=>$input['result_unit'] ?? 's',
        ':place'=>isset($input['place'])?(int)$input['place']:null,
        ':heat'=>isset($input['heat'])?(int)$input['heat']:null,
        ':round'=>$input['round'] ?? 'Final',
        ':status'=>$input['status'] ?? 'OK',
        ':wind'=>isset($input['wind'])?(float)$input['wind']:null
      ]);
      echo json_encode(['ok'=>true]); break;

    case 'competitive_table':
      $q="SELECT r.sched_id,e.name AS event_name,r.place,
                COALESCE(CONCAT(s.last_name, ', ', s.first_name), CONCAT('House ', r.house_code)) AS competitor,
                r.result_value,r.result_unit
         FROM competitive_results r
         JOIN scheduled_events se ON se.id=r.sched_id
         JOIN events e ON e.id=se.event_id
         LEFT JOIN students s ON s.id=r.student_id
         WHERE r.round='Final' AND r.status='OK' AND r.place IN (1,2,3)
         ORDER BY e.name, r.place ASC";
      echo json_encode(['ok'=>true,'rows'=>$pdo->query($q)->fetchAll()]); break;

    default:
      http_response_code(400); echo json_encode(['ok'=>false,'error'=>'Unknown action']);
  }
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
