<?php
// lib/db.php
require_once 'config.php';

function get_pdo(): PDO {
  // sanity check: config constants exist
  foreach (['DB_HOST','DB_NAME','DB_USER','DB_PASS'] as $c) {
    if (!defined($c)) {
      throw new RuntimeException("Config constant {$c} is not defined. Check config.php include.");
    }
  }

  static $pdo = null;
  if ($pdo === null) {
    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
  }
  return $pdo;
}
